<?php
/**
 * UTECH SMS Gateway - Configuration File
 * Uukow Data Exchange System
 */

// Security Token - CHANGE THIS TO A STRONG RANDOM STRING
define('SECRET_TOKEN', 'CHANGE_THIS_TO_YOUR_SECURE_TOKEN_MIN_16_CHARS');

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'uukow_data_exchange');
define('DB_USER', 'root');
define('DB_PASS', '');

// API Configuration
define('API_TIMEOUT', 30);
define('ENABLE_LOGS', true);
define('LOG_FILE', __DIR__ . '/logs/gateway.log');

// Operator Configuration
// Set to true if you have direct API access to operators
define('USE_OPERATOR_API', false);

// Operator API Endpoints (if available)
define('HORMUUD_API_URL', 'https://api.hormuud.com/provision');
define('SOMNET_API_URL', 'https://api.somnet.com/provision');
define('SOMTEL_API_URL', 'https://api.somtel.com/provision');

// SMS Gateway Configuration (fallback method)
define('SMS_GATEWAY_URL', 'http://localhost/sms_gateway/send.php');
define('SMS_GATEWAY_USERNAME', 'your_username');
define('SMS_GATEWAY_PASSWORD', 'your_password');

// Data Bundle Configuration
// Map payment amounts to data bundles
$BUNDLE_MAPPING = [
    '1.00' => '1GB',
    '1' => '1GB',
    '2.00' => '2GB',
    '2' => '2GB',
    '3.00' => '3GB',
    '3' => '3GB',
    '5.00' => '5GB',
    '5' => '5GB',
    '10.00' => '10GB',
    '10' => '10GB',
];

// Shortcodes for different operators
$OPERATOR_SHORTCODES = [
    'hormuud' => '*712*',
    'somnet' => '*151*',
    'somtel' => '*888*',
];

// Payment sender identifiers
$PAYMENT_SENDERS = [
    'hormuud' => 'Hormuud',
    'somnet' => 'Somnet',
    'somtel' => 'Somtel',
];

// Timezone
date_default_timezone_set('Africa/Mogadishu');

// Create logs directory if it doesn't exist
if (!file_exists(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0755, true);
}

